/***********************************
 *								   *
 *	Scatter Search C code		   *
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *
 *								   *
 ***********************************/

#include "SS3f.h"

int main(void)
{
	SS *pb;					/* Pointer problem				 */
	int b         =  10;	/* Size of Reference Set		 */
	int PSize     = 100;	/* Size of P					 */
	int Iter	  =   1;	/* Current iteration			 */
	int NRebuild  =   5;	/* Maximum number of rebuildings */
	int *sol,value;

	pb  = SSProblem_Definition("example_lop",b,PSize);

	SSCreate_P(pb);
	SSCreate_RefSet(pb);

	while(Iter<=NRebuild)
	{
		if(pb->rs->NewSolutions)
			SSDynamicUpdate_RefSet(pb);
		else
		{
			SSRebuild_RefSet(pb);
			Iter++;
		}
	}

	sol	= SSInt_array(pb->nvar);
	SSBestSol(pb,sol,&value);
	printf("\nBest Value = %d\n",value);

	free(sol+1);
	SSFree_DataStructures(pb);
	return 0;
}

int sol_value(SS *pb,int sol[])
{
	int i,j,value=0;                                      
	
	for(i=1;i<pb->nvar;i++)
	for(j=i+1;j<=pb->nvar;j++)
		value += pb->data[sol[i]][sol[j]];
	
	return value;
}